% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program TexturePattern.m
c = 0.50;          % contrast of Gabor
f = 1/8;           % spatial frequency of Gabor in 1/pixels
t = [22.5 67.5 112.5 157.5]*pi/180; % 4 different Gabor tilts
                                    % in polar angles
s = 4;             % standard deviation of Gabor window 
[x, y] = meshgrid(-16:15, 16:-1:-15);
for i = 1:4
    M(:, :, i) = 127*(1 + c*sin(2.0*pi*f*(y*sin(t(i)) + x*cos(t(i)))).*exp(-(x.^2 + y.^2)/2/s^2));
end

[Tx,  Ty] = meshgrid(1:40:320, 1:40:320);
T = 127*ones(320,  320);

for i = 1:8
    for j = 1:8
        M_index = round(3*rand(1)) + 1;
        Tx(i,  j) = Tx(i,  j) + round(rand(1)*6)
        Ty(i,  j) = Ty(i,  j) + round(rand(1)*6)
        T(Ty(i,  j):(Ty(i,  j)+31), Tx(i,  j):(Tx(i,  j) + 31)) = M(:, :,  M_index);
    end
end

showImage(T,   'grayscale');